//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <WinLDap.H>
#include <ShlWapi.H>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CCallback : public IBindStatusCallback
{
public:
	CCallback();
	~CCallback();

    STDMETHOD(OnStartBinding)(
        /* [in] */ DWORD dwReserved,
        /* [in] */ IBinding __RPC_FAR *pib)
        { return E_NOTIMPL; }

    STDMETHOD(GetPriority)(
        /* [out] */ LONG __RPC_FAR *pnPriority)
        { return E_NOTIMPL; }

    STDMETHOD(OnLowResource)(
        /* [in] */ DWORD reserved)
        { return E_NOTIMPL; }

    STDMETHOD(OnProgress)(
        /* [in] */ ULONG ulProgress,
        /* [in] */ ULONG ulProgressMax,
        /* [in] */ ULONG ulStatusCode,
        /* [in] */ LPCWSTR wszStatusText);

    STDMETHOD(OnStopBinding)(
        /* [in] */ HRESULT hresult,
        /* [unique][in] */ LPCWSTR szError)
        { return E_NOTIMPL; }

    STDMETHOD(GetBindInfo)(
        /* [out] */ DWORD __RPC_FAR *grfBINDF,
        /* [unique][out][in] */ BINDINFO __RPC_FAR *pbindinfo)
        { return E_NOTIMPL; }

    STDMETHOD(OnDataAvailable)(
        /* [in] */ DWORD grfBSCF,
        /* [in] */ DWORD dwSize,
        /* [in] */ FORMATETC __RPC_FAR *pformatetc,
        /* [in] */ STGMEDIUM __RPC_FAR *pstgmed)
        { return E_NOTIMPL; }

    STDMETHOD(OnObjectAvailable)(
        /* [in] */ REFIID riid,
        /* [iid_is][in] */ IUnknown __RPC_FAR *punk)
        { return E_NOTIMPL; }

    // IUnknown methods.  Note that IE never calls any of these methods, since
    // the caller owns the IBindStatusCallback interface, so the methods all
    // return zero/E_NOTIMPL.

    STDMETHOD_(ULONG,AddRef)()
        { return 0; }

    STDMETHOD_(ULONG,Release)()
        { return 0; }

    STDMETHOD(QueryInterface)(
    /* [in] */ REFIID riid,
    /* [iid_is][out] */ void __RPC_FAR *__RPC_FAR *ppvObject)
        { return E_NOTIMPL; }
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CCallback::CCallback()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CCallback::~CCallback()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HRESULT CCallback::OnProgress(ULONG ulProgress, ULONG ulProgressMax, ULONG ulStatusCode, LPCWSTR wszStatusText)
{
    static char lsAmtDownloaded[256];
    static char lsTotalSize[256];
//  static char lsStatusText[256];
    static char lsCustomStatusMsg[256];
    static ULONG LastProgress = 0;

/*
    if(wszStatusText != NULL)
    {
        int CWStrLen = wcslen(wszStatusText);
        LdapUnicodeToUTF8(wszStatusText, CWStrLen, lsStatusText, 255);
        lsStatusText[CWStrLen] = '\0';
        Set_Text(StatusText_hWnd, lsStatusText);
    }
*/

    StrFormatByteSize(ulProgress, lsAmtDownloaded, 255);
    StrFormatByteSize(ulProgressMax, lsTotalSize, 255);

    if(0 != ulProgressMax)
    {
        if(ulProgress > (LastProgress + 10000))
        {
            float lfProgress    = (float) ulProgress;
            float lfProgressMax = (float) ulProgressMax;
            float lfPercentage  = (float) ((lfProgress / lfProgressMax) * 100);

            sprintf(lsCustomStatusMsg, "Downloaded %s of %s (%.1f%%)", lsAmtDownloaded, lsTotalSize, lfPercentage);
            Set_Text(StatusText_hWnd, lsCustomStatusMsg);
            SendMessage(ProgressBar_hWnd, PBM_SETPOS, (ULONG)lfPercentage, 0);
            LastProgress = ulProgress;
        }
    }
    else{
        if(ulProgress > (LastProgress + 10000))
        {
            sprintf(lsCustomStatusMsg, "Downloaded %s (total size unknown)", lsAmtDownloaded);
            Set_Text(StatusText_hWnd, lsCustomStatusMsg);
            LastProgress = ulProgress;
        }
    }

    return S_OK;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ClientUpdate(char *HTTPURL)
{
    char StatusTemp[255 + 1];
    char TargetFile[255 + 1];

    CCallback Callback;

    sprintf(TargetFile, "%s\\%s", gsPath, "Update.Exe");

    HRESULT HResult = URLDownloadToFile(NULL, HTTPURL, TargetFile, 0, &Callback);

    if(SUCCEEDED(HResult))
    {
        Set_Text(StatusText_hWnd, "Download completed successfully!");
        Sleep(5000);

        MyExecute(gsServiceControlExe, "/stop");
        MyExecute(TargetFile, "/sp- /silent");

        // Update code here
    }
    else{
        sprintf(StatusTemp, "Download failed. Error = 0x%08lX", HResult);
        Set_Text(StatusText_hWnd, StatusTemp);
        MessageBox(MainDialog_hWnd, StatusTemp, TitleCaption, MB_APPLMODAL+MB_ICONERROR);
        RestartClientService();
    }

    EndDialog(MainDialog_hWnd, 0);

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

